import { View, Text, Pressable, ScrollView } from "react-native";
import React from "react";
import VariationOptionStyle from "./VariationOption.style";
import ProgressiveImage from "../../../../../../../src/components/ProgressiveImage";
import RightIcon from "../../../../../../../assets/svgs/product details/rightIcon.svg";
import VariationContent from "./VariationContent";
import useLangTranslation from "../../../../../../../hooks/useLangTranslation";
import CustomSVG from "../../../../../../../src/components/CustomSVG/CustomSVG";

const VariationOption = (props) => {
    const { trans } = useLangTranslation();
    const { images, onOpenModal, onCloseModal } = props;
    const variationOptionStyle = VariationOptionStyle();

    return (
        <>
            <View style={variationOptionStyle.headerCont}>
                <Text style={variationOptionStyle.title}>{trans("Variations")}</Text>
                <Pressable hitSlop={10} onPress={onOpenModal} style={variationOptionStyle.arrowStyle}>
                    <CustomSVG svgIcon={RightIcon} isRtl={1} fill={"#898989"} />
                </Pressable>
            </View>
            <View style={variationOptionStyle.scrollViewStyle}>
                <ScrollView
                    horizontal
                    showsHorizontalScrollIndicator={false}
                >
                    <Pressable
                        style={variationOptionStyle.variationCont}
                        onPress={onOpenModal}
                        onStartShouldSetResponder={() => false}
                    >
                        {images.map((image, index) => (
                            <ProgressiveImage
                                key={index}
                                source={{ uri: image }}
                                style={variationOptionStyle.image}
                            />
                        ))}
                    </Pressable>
                </ScrollView>
            </View>
            <VariationContent {...props} onCloseModal={onCloseModal} />
        </>
    );
};

export default VariationOption;
